---
name: cloud-cost-analysis
description: Multi-cloud cost analysis and optimization expertise for FinOps practices
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
  - WebFetch
---

# Cloud Cost Analysis Skill

## Overview

Specialized skill for multi-cloud cost analysis and optimization. Provides deep expertise in FinOps practices, cost visibility, and resource optimization across AWS, GCP, and Azure.

## Capabilities

### AWS Cost Analysis
- AWS Cost Explorer queries and analysis
- Cost and Usage Reports (CUR) interpretation
- Reserved Instance utilization analysis
- Savings Plans recommendations
- Spot Instance strategy evaluation
- AWS Budgets configuration

### GCP Cost Analysis
- GCP Billing export analysis
- Committed use discounts evaluation
- Preemptible/Spot VM strategy
- BigQuery cost analysis
- GCP Budget alerts setup
- Recommender API insights

### Azure Cost Analysis
- Azure Cost Management queries
- Reserved VM Instance analysis
- Azure Hybrid Benefit evaluation
- Spot VM recommendations
- Azure Budgets configuration
- Azure Advisor cost recommendations

### Resource Optimization
- Rightsizing recommendations
- Idle resource identification
- Storage tier optimization
- Network egress cost reduction
- Containerization cost benefits
- Serverless cost comparison

### Cost Allocation
- Tagging strategy design
- Cost allocation rules
- Showback/chargeback implementation
- Unit economics calculation
- Business unit attribution
- Project/team cost breakdown

### Forecasting and Budgeting
- Cost trend analysis
- Forecast modeling
- Budget threshold alerts
- Anomaly detection
- Capacity planning cost modeling

### Governance
- Cost policies and guardrails
- Approval workflows for expensive resources
- Spending limits enforcement
- FinOps maturity assessment
- KPI definition and tracking

## Target Processes

- `cost-optimization.js` - Cost optimization initiatives
- `auto-scaling.js` - Cost-aware scaling policies
- `iac-implementation.js` - Cost-tagged infrastructure

## Usage Context

This skill is invoked when processes require:
- Analyzing cloud spending across providers
- Identifying cost optimization opportunities
- Implementing cost allocation and tagging
- Setting up budgets and alerts
- Designing cost governance policies

## Dependencies

- AWS Cost Explorer API access
- GCP Billing API access
- Azure Cost Management API access
- Cloud provider credentials with billing read access

## Output Formats

- Cost analysis reports
- Optimization recommendations
- Tagging strategy documents
- Budget configurations
- FinOps dashboards
- Savings forecasts
