---
name: competitor-analysis
description: Deep competitive intelligence and market positioning analysis
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - WebSearch
  - WebFetch
metadata:
  specialization: entrepreneurship
  domain: business
  category: Market Intelligence
  skill-id: SK-006
---

# Competitor Analysis Skill

## Overview

The Competitor Analysis skill provides deep competitive intelligence and market positioning analysis capabilities. It enables startups to systematically analyze competitors, identify market opportunities, and develop differentiated positioning strategies that resonate with investors and customers.

## Capabilities

### Core Functions
- **Website Analysis**: Analyze competitor websites for positioning, messaging, and features
- **Funding Tracking**: Track competitor funding rounds and announcements
- **Feature Comparison**: Generate comprehensive feature comparison matrices
- **Positioning Maps**: Create competitive positioning maps and perceptual grids
- **White Space Identification**: Identify market opportunities and white space
- **Pricing Analysis**: Monitor and analyze competitor pricing strategies
- **Moat Analysis**: Extract and evaluate competitive advantages and moats
- **Slide Generation**: Generate investor-ready competitive analysis slides

### Advanced Features
- Competitive response prediction
- Market share estimation
- Competitor strategy inference
- Product roadmap analysis
- Team and talent tracking
- Partnership ecosystem mapping
- Customer review sentiment analysis
- Technology stack analysis

## Usage

### Input Requirements
- List of known competitors
- Industry or market category
- Product/service description
- Target customer segments
- Key differentiating factors
- Geographic focus

### Output Deliverables
- Competitor profiles with key metrics
- Feature comparison matrix
- Positioning map visualization
- White space opportunity analysis
- Competitive advantages summary
- Investor-ready competitive slides
- Differentiation recommendations

### Process Integration
This skill integrates with the following processes:
- `competitive-landscape-mapping.js` - Primary integration for all phases
- `investor-pitch-deck.js` - Competitive landscape slides
- `gtm-strategy-development.js` - Competitive positioning strategy
- `product-market-fit-assessment.js` - Market differentiation analysis

### Example Invocation
```
Skill: competitor-analysis
Context: Entering the project management SaaS market
Input:
  - Known Competitors: [Asana, Monday.com, ClickUp, Notion]
  - Our Focus: AI-powered project automation
  - Target Segment: Remote engineering teams
  - Differentiators: ML-based task assignment, automated reporting
Output:
  - Detailed competitor profiles
  - Feature comparison matrix
  - Positioning map showing opportunity space
  - White space analysis: AI automation gap
  - Recommended positioning statement
  - Competitive slide for pitch deck
```

## Dependencies

- Web scraping and analysis capabilities
- News and announcement monitoring
- Crunchbase/PitchBook data access
- Visualization libraries for positioning maps
- Sentiment analysis for reviews

## Best Practices

1. Analyze both direct and indirect competitors
2. Include emerging and potential future competitors
3. Track competitor changes over time, not just snapshots
4. Focus on customer perception, not just features
5. Identify sustainable competitive advantages vs. temporary ones
6. Document data sources and collection dates
7. Update competitive analysis quarterly at minimum
8. Consider ecosystem partners as potential competitors
9. Analyze competitor weaknesses without being dismissive
10. Use objective criteria for positioning comparisons
