---
name: computational-environment-manager
description: Manage reproducible computational environments
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
metadata:
  specialization: mathematics
  domain: science
  category: reproducibility
  phase: 6
---

# Computational Environment Manager

## Purpose

Provides management capabilities for reproducible computational environments in mathematical research.

## Capabilities

- Docker container configuration
- Conda environment specification
- Package version pinning
- Random seed management
- Platform independence verification
- Execution trace logging

## Usage Guidelines

1. **Environment Specification**: Define complete environment specs
2. **Version Pinning**: Pin all package versions
3. **Seed Management**: Control random seeds for reproducibility
4. **Documentation**: Document environment setup procedures

## Tools/Libraries

- Docker
- Conda
- pip
- Julia Pkg
