---
name: consensus-protocol-library
description: Reference implementations and specifications of consensus protocols
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
metadata:
  specialization: computer-science
  domain: science
  category: distributed-systems
  phase: 6
---

# Consensus Protocol Library

## Purpose

Provides expert guidance on consensus protocol design, analysis, and implementation for distributed systems.

## Capabilities

- Paxos, Raft, PBFT specifications
- Protocol comparison matrix
- Safety/liveness property templates
- Message complexity analysis
- Protocol variant catalog
- Failure mode analysis

## Usage Guidelines

1. **Protocol Selection**: Choose appropriate consensus protocol
2. **Specification Review**: Understand protocol specification
3. **Property Verification**: Verify safety and liveness
4. **Comparison**: Compare protocols for use case
5. **Implementation**: Guide implementation decisions

## Tools/Libraries

- TLA+ specifications
- Reference implementations
- Protocol documentation
