---
name: conservation-assessment
description: Assess condition of artworks and cultural objects, develop treatment proposals, and document conservation interventions following AIC ethical guidelines
allowed-tools: Read, Grep, Write, Edit, Glob, WebFetch
---

# Conservation Assessment

Assess condition of artworks and cultural objects, develop treatment proposals, and document conservation interventions following AIC ethical guidelines.

## Overview

This skill provides methodologies for professional conservation assessment of cultural property. It encompasses condition evaluation, treatment proposal development, documentation standards, and ethical decision-making following American Institute for Conservation guidelines.

## Capabilities

### Condition Assessment
- Conduct systematic visual examination
- Identify materials and techniques
- Document deterioration and damage
- Assess structural stability
- Evaluate previous interventions

### Treatment Planning
- Develop treatment options
- Assess risks and benefits
- Consider reversibility principles
- Plan testing protocols
- Estimate time and resources

### Documentation Standards
- Create written condition reports
- Produce photographic documentation
- Develop condition diagrams
- Document treatment procedures
- Maintain conservation records

### Ethical Decision-Making
- Apply AIC Code of Ethics
- Consider cultural significance
- Respect original materials and intent
- Balance access and preservation
- Engage stakeholders appropriately

## Usage Guidelines

### Assessment Process
1. Review object history and documentation
2. Conduct visual examination under various lighting
3. Document current condition thoroughly
4. Identify materials through examination and testing
5. Assess structural and chemical stability
6. Develop treatment recommendations

### Documentation Requirements
- Before, during, and after photography
- Written condition descriptions
- Materials identification records
- Treatment procedure notes
- Recommendations for future care

### Ethical Considerations
- Minimize intervention
- Maintain reversibility where possible
- Document all treatments thoroughly
- Respect cultural protocols
- Consult specialists when needed

## Integration Points

### Related Processes
- Conservation Treatment Process
- Condition Reporting Process
- Preventive Conservation Process

### Collaborating Skills
- collection-documentation
- risk-mitigation-planning

## References

- AIC Code of Ethics and Guidelines for Practice
- AIC Commentaries to the Guidelines
- Conservation documentation standards
- Materials analysis methodologies
