# Container Images Skill

Docker and OCI container image expertise for building, optimizing, and securing container images.

## ID
SK-007

## Category
Container Management

## Quick Reference

| Aspect | Details |
|--------|---------|
| Slug | `container-images` |
| Primary Use | Container image development, optimization, and security |
| Dependencies | Docker CLI, vulnerability scanners, registry access |
| Process Integration | container-image-management.js, security-scanning.js, cicd-pipeline-setup.js |

## Key Capabilities

- **Dockerfile Optimization**: Multi-stage builds, layer caching
- **Image Size Reduction**: Minimal base images, dependency pruning
- **Security Scanning**: Vulnerability analysis and remediation
- **Registry Management**: Push, pull, tag, retention policies
- **Build Integration**: CI/CD pipeline integration

## When to Use

Use this skill when you need to:
- Create or optimize Dockerfiles
- Reduce container image sizes
- Address image security vulnerabilities
- Set up container build pipelines
- Manage container registries

## Related

- **Skills**: cicd-pipelines (SK-004), secrets-management (SK-008)
- **Agents**: secops-expert (AG-004), cicd-specialist (AG-005)
