---
name: core-competency
description: Organizational capability and core competency assessment using strategic frameworks
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - WebSearch
  - WebFetch
metadata:
  specialization: business-strategy
  domain: business
  category: Capability Analysis
  skill-id: SK-020
---

# Core Competency Analysis Skill

## Overview

The Core Competency Analysis skill enables systematic organizational capability and core competency assessment. It leverages strategic frameworks including Prahalad-Hamel criteria, VRIO/VRIN analysis, and resource-based view methodologies to identify, evaluate, and develop sustainable competitive advantages rooted in organizational capabilities.

## Capabilities

### Core Competency Identification
- Map organizational capabilities across functions
- Identify potential core competencies
- Distinguish competencies from capabilities
- Categorize competencies by type
- Document competency evidence and manifestations

### Prahalad-Hamel Criteria Application
- Assess access to multiple markets
- Evaluate contribution to customer benefits
- Determine difficulty for competitors to imitate
- Score competencies against three tests
- Classify true core competencies

### VRIO/VRIN Analysis
- Assess Value: Does the resource enable value creation?
- Assess Rarity: Is the resource rare among competitors?
- Assess Imitability: Is the resource costly to imitate?
- Assess Organization: Is the firm organized to exploit?
- Determine competitive implication (disadvantage to sustained advantage)

### Competitive Advantage Assessment
- Map competencies to competitive positioning
- Evaluate advantage sustainability
- Assess advantage magnitude
- Identify competitive parity capabilities
- Determine temporary vs sustained advantages

### Capability Gap Analysis
- Compare current vs required capabilities
- Identify critical capability gaps
- Assess gap severity and urgency
- Prioritize gaps by strategic importance
- Recommend gap closure strategies

### Competency Sustainability Evaluation
- Assess durability of competitive advantage
- Evaluate threats to competency erosion
- Identify capability reinvestment needs
- Monitor competitor capability development
- Plan competency renewal strategies

### Strategic Importance Scoring
- Score competencies by strategic relevance
- Assess alignment with strategy
- Evaluate future importance trends
- Prioritize development investments
- Balance portfolio of competencies

### Capability Development Roadmap
- Design capability building plan
- Sequence development initiatives
- Identify capability dependencies
- Allocate development resources
- Set capability milestones

### Make vs Buy vs Partner Analysis
- Evaluate internal development viability
- Assess acquisition opportunities
- Identify partnership potential
- Compare options by time, cost, risk
- Recommend sourcing strategy

### Resource-Based View Analysis
- Inventory tangible and intangible resources
- Assess resource heterogeneity
- Evaluate resource immobility
- Map resources to capabilities
- Design resource leverage strategies

## Process Integration

This skill integrates with the following processes:

- **core-competency-assessment.js**: Primary process for all phases of competency analysis
- **swot-analysis.js**: Provides strengths analysis foundation
- **ma-target-screening.js**: Enables capability fit assessment
- **operating-model-redesign.js**: Supports capability design decisions

## Usage

### Complete Core Competency Assessment
```
Use the core-competency skill for comprehensive analysis:
1. Inventory organizational capabilities
2. Apply Prahalad-Hamel criteria for core competency identification
3. Conduct VRIO analysis on potential competencies
4. Assess competitive advantage implications
5. Identify capability gaps
6. Develop capability roadmap
```

### Competitive Advantage Analysis
```
Use the core-competency skill to evaluate competitive advantage:
1. Map current capabilities to competitive position
2. Apply VRIO framework
3. Assess advantage sustainability
4. Identify threats and opportunities
5. Recommend advantage enhancement strategies
```

### Capability Development Planning
```
Use the core-competency skill to plan capability building:
1. Identify required capabilities
2. Assess current capability gaps
3. Evaluate make vs buy vs partner options
4. Design development roadmap
5. Establish governance and milestones
```

## Dependencies

- Prahalad-Hamel core competency frameworks
- VRIO/VRIN analysis templates
- Resource-based view methodology
- Capability mapping tools
- Competitive advantage assessment frameworks

## Best Practices

1. **Be Rigorous in Identification**: True core competencies are rare - most capabilities are not core
2. **Apply Multiple Frameworks**: Use Prahalad-Hamel AND VRIO for robust assessment
3. **Focus on Future Relevance**: Assess whether competencies will matter in future markets
4. **Invest Continuously**: Core competencies require ongoing investment to maintain
5. **Link to Strategy**: Competency development must serve strategic objectives

## Output Formats

- Capability Inventory Matrix
- Core Competency Assessment Report
- VRIO Analysis Scorecard
- Competitive Advantage Map
- Capability Gap Analysis Report
- Development Roadmap Document
- Make/Buy/Partner Recommendation
- Resource-Based View Analysis
