---
name: crayon-competitive
description: Crayon competitive intelligence platform for market monitoring
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Bash
  - WebFetch
metadata:
  specialization: sales
  domain: business
  priority: P1
  integration-points:
    - Crayon API
---

# Crayon Competitive

## Overview

The Crayon Competitive skill provides integration with Crayon's competitive intelligence platform for competitor tracking, battlecard content retrieval, win/loss data aggregation, and market movement signals. This skill keeps sales teams informed about competitive dynamics in real-time.

## Capabilities

### Competitor Tracking
- Monitor competitor website changes
- Track pricing and product updates
- Alert on news and announcements
- Follow executive movements

### Battlecard Access
- Retrieve up-to-date battlecard content
- Access positioning statements
- Get objection handling guidance
- Surface competitive differentiators

### Win/Loss Intelligence
- Aggregate win/loss data and patterns
- Identify competitive trends
- Track win rates by competitor
- Surface success strategies

### Market Signals
- Monitor market movement indicators
- Track industry trends
- Identify emerging competitors
- Assess market positioning shifts

## Usage

### Competitive Update
```
Retrieve recent competitive updates and alerts for an upcoming deal involving a specific competitor.
```

### Battlecard Retrieval
```
Access the current battlecard for a competitor with latest positioning and objection handling.
```

### Win/Loss Analysis
```
Analyze win/loss patterns against a specific competitor to identify success strategies.
```

## Enhances Processes

- competitive-battle-cards
- win-loss-analysis
- sales-playbook-development

## Dependencies

- Crayon subscription
- Competitor tracking configuration
- CRM integration for win/loss data
