---
name: critical-theory-application
description: Apply theoretical frameworks (postcolonial, feminist, Marxist, post-structuralist) to cultural texts and phenomena
allowed-tools: Read, Grep, Write, Edit, Glob, WebFetch
---

# Critical Theory Application

Apply theoretical frameworks including postcolonial, feminist, Marxist, and post-structuralist approaches to cultural texts and phenomena.

## Overview

This skill enables application of critical theoretical frameworks to cultural analysis. It encompasses framework selection, analytical application, and interpretation development to produce theoretically informed readings of texts and cultural phenomena.

## Capabilities

### Theoretical Frameworks
- Postcolonial theory
- Feminist criticism
- Marxist analysis
- Post-structuralism
- Queer theory

### Framework Application
- Concept identification
- Analytical lens selection
- Systematic application
- Evidence marshaling
- Argument construction

### Interpretive Development
- Reading production
- Argument articulation
- Counter-argument consideration
- Nuanced analysis
- Scholarly positioning

### Theoretical Synthesis
- Framework combination
- Interdisciplinary integration
- Historical contextualization
- Methodological reflection
- Contribution identification

## Usage Guidelines

### Application Process
1. Select appropriate framework(s)
2. Identify key concepts
3. Apply to text/phenomenon
4. Develop interpretation
5. Consider alternatives
6. Articulate argument
7. Position scholarly contribution

### Framework Selection Criteria
- Research question fit
- Text/phenomenon appropriateness
- Scholarly conversation
- Analytical goals
- Disciplinary norms

### Analytical Principles
- Theoretical rigor
- Textual evidence
- Contextual awareness
- Self-reflexivity
- Scholarly engagement

## Integration Points

### Related Processes
- Literary Theoretical Application
- Comparative Literature Analysis
- Close Reading Analysis

### Collaborating Skills
- literary-close-reading
- citation-scholarly-apparatus
- grant-narrative-writing

## References

- Critical theory anthologies
- Theoretical methodology texts
- Disciplinary applications
- Scholarly debates
