---
name: curatorial-research
description: Conduct art historical research, provenance investigation, and scholarly analysis to inform exhibitions, acquisitions, and publications using primary and secondary sources
allowed-tools: Read, Grep, Write, Edit, Glob, WebFetch, WebSearch
---

# Curatorial Research

Conduct comprehensive art historical research, provenance investigation, and scholarly analysis to inform curatorial decisions for exhibitions, acquisitions, and publications.

## Overview

This skill provides methodologies and frameworks for conducting rigorous curatorial research. It encompasses art historical analysis, provenance research, scholarly writing, and the critical evaluation of primary and secondary sources to support museum and gallery operations.

## Capabilities

### Art Historical Research
- Conduct iconographic and iconological analysis
- Apply formal analysis methodologies
- Research artist biographies and oeuvres
- Investigate artistic movements and periods
- Analyze stylistic development and influences

### Provenance Investigation
- Trace ownership history of artworks
- Identify gaps in provenance records
- Research exhibition and publication history
- Investigate authenticity questions
- Document chain of custody

### Source Evaluation
- Assess reliability of primary sources
- Evaluate scholarly secondary literature
- Identify archival resources
- Navigate digital humanities databases
- Cross-reference multiple source types

### Scholarly Documentation
- Prepare catalogue raisonne entries
- Write exhibition catalog essays
- Document condition and conservation history
- Create object files and records
- Generate bibliography and citations

## Usage Guidelines

### Research Process
1. Define research questions and scope
2. Identify relevant archival collections
3. Conduct systematic literature review
4. Analyze primary source materials
5. Synthesize findings into coherent narrative
6. Document sources and methodology

### Provenance Standards
- Follow AAM Guidelines on Object Status
- Adhere to AAMD Object Registry protocols
- Document all ownership transfers
- Flag potential title issues
- Note exhibition and loan history

### Documentation Requirements
- Maintain detailed research notes
- Create source citation records
- Document visual analysis observations
- Record interview and correspondence summaries
- Preserve digital and physical source copies

## Integration Points

### Related Processes
- Curatorial Research Process
- Exhibition Development Process
- Collection Management Process
- Loan Agreement Process

### Collaborating Skills
- collection-documentation
- interpretive-writing
- grant-proposal-writing

## References

- Getty Research Institute resources
- IFAR Provenance Guide
- AAM Standards and Best Practices
- College Art Association guidelines
