---
name: curriculum-gap-analysis
description: Identify gaps, overlaps, and misalignments in curriculum coverage through systematic comparison with standards and learning progressions
allowed-tools: Read, Grep, Write, Edit, Glob, WebFetch
---

# Curriculum Gap Analysis

Identify gaps, overlaps, and misalignments in curriculum coverage through systematic comparison with standards and learning progressions.

## Overview

This skill enables systematic analysis of curriculum to identify gaps, overlaps, and misalignments. It encompasses comparison with standards, progression analysis, and improvement planning to ensure comprehensive and coherent curriculum coverage.

## Capabilities

### Gap Identification
- Compare curriculum to standards
- Identify missing content
- Find skill gaps
- Detect assessment gaps
- Map coverage comprehensively

### Overlap Analysis
- Identify redundant content
- Find unnecessary repetition
- Assess time allocation
- Map cross-course overlaps
- Evaluate scope efficiency

### Progression Analysis
- Evaluate vertical alignment
- Assess prerequisite sequences
- Check skill building
- Identify progression gaps
- Verify scaffolding

### Improvement Planning
- Prioritize gap remediation
- Recommend additions
- Suggest consolidations
- Plan implementation
- Track improvements

## Usage Guidelines

### Analysis Process
1. Gather curriculum documents
2. Map to standards/requirements
3. Identify gaps in coverage
4. Find overlaps and redundancies
5. Analyze progressions
6. Document findings
7. Develop recommendations

### Gap Categories
- Content not addressed
- Skills not developed
- Depth insufficient
- Assessment missing
- Sequence problems

### Documentation Standards
- Comprehensive mapping
- Clear gap descriptions
- Prioritized recommendations
- Implementation timeline
- Success metrics

## Integration Points

### Related Processes
- Curriculum Mapping
- Learning Progression Development
- Standards-Based Alignment

### Collaborating Skills
- standards-alignment-mapping
- learning-objectives-writing
- quality-assurance-review

## References

- Curriculum mapping methodologies
- Standards alignment frameworks
- Jacobs curriculum mapping
- Gap analysis techniques
