---
name: data-encoder
description: Classical data encoding skill for quantum machine learning applications
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
metadata:
  specialization: quantum-computing
  domain: science
  category: quantum-ml
  phase: 6
---

# Data Encoder

## Purpose

Provides expert guidance on encoding classical data into quantum states for machine learning applications, balancing expressiveness with circuit complexity.

## Capabilities

- Angle encoding
- Amplitude encoding
- IQP encoding
- Hardware-efficient encoding
- Encoding expressibility analysis
- Data re-uploading strategies
- Feature scaling for encoding
- Encoding depth optimization

## Usage Guidelines

1. **Feature Analysis**: Understand data dimensionality and structure
2. **Encoding Selection**: Choose encoding based on data type and qubit budget
3. **Scaling**: Apply appropriate normalization for encoding method
4. **Depth Analysis**: Balance encoding expressivity with circuit depth
5. **Verification**: Validate encoded states capture relevant features

## Tools/Libraries

- PennyLane
- Qiskit Machine Learning
- Cirq
- TensorFlow Quantum
- NumPy
