---
name: data-versioning-manager
description: Skill for managing data versions and provenance
allowed-tools:
  - Bash
  - Read
  - Write
metadata:
  specialization: scientific-discovery
  domain: science
  category: Reproducibility
  skill-id: SK-SCIDISC-025
---

# Data Versioning Manager Skill

## Purpose

Manage data versions, track provenance, and ensure data lineage for reproducible scientific research.

## Capabilities

- Version datasets
- Track data lineage
- Document transformations
- Enable rollback
- Support collaboration
- Generate provenance

## Usage Guidelines

1. Initialize versioning
2. Track data changes
3. Document transformations
4. Create snapshots
5. Manage branches
6. Export provenance

## Process Integration

Works within scientific discovery workflows for:
- Data management
- Reproducibility support
- Collaboration enabling
- Audit compliance

## Configuration

- Version control system
- Storage backends
- Metadata schemas
- Access controls

## Output Artifacts

- Version histories
- Provenance records
- Transformation logs
- Data snapshots
