---
name: dialogue-crafting
id: SK-FTV-004
version: 1.0.0
description: Create character-specific dialogue with distinct voices, subtext, and naturalistic speech patterns
specialization: film-tv-production
---

# Dialogue Crafting Skill

## Purpose

Create distinctive, character-specific dialogue that reveals personality, advances plot, and creates subtext. Great dialogue sounds effortless but is carefully constructed to serve multiple purposes simultaneously.

## The 5 Functions of Dialogue

Every line should serve at least one:

| Function | Description | Example |
|----------|-------------|---------|
| **Character** | Reveals who they are | Vocabulary, syntax, rhythm |
| **Plot** | Advances the story | Information, decisions |
| **Conflict** | Creates tension | Opposition, evasion |
| **Subtext** | Says what isn't said | What they mean vs. say |
| **Atmosphere** | Sets mood/tone | Rhythm, word choice |

## Character Voice

### Voice Components

```
VOCABULARY
├── Education level (erudite vs. simple)
├── Regional dialect (y'all, eh, innit)
├── Professional jargon (cop, doctor, lawyer)
├── Era/period (23-skidoo, YOLO)
└── Cultural background

SYNTAX
├── Sentence length (short/punchy vs. long/flowing)
├── Grammar (proper vs. informal)
├── Contractions (can't vs. cannot)
└── Incomplete sentences

RHYTHM
├── Pace (rapid-fire vs. measured)
├── Pauses (significant silences)
├── Interruptions (talks over others)
└── Patterns (repeats certain phrases)

QUIRKS
├── Catchphrases
├── Verbal tics (um, like, you know)
├── Mispronunciations
└── Unique expressions
```

### Voice Examples

**Educated, Formal:**
```
"I find your proposition intriguing, though I confess
to harboring certain reservations regarding the
temporal constraints you've outlined."
```

**Street-Smart, Informal:**
```
"Look, you want my help? Fine. But we do this
my way, on my time. You don't like it?
Door's right there."
```

**Technical Professional:**
```
"The arterial damage is extensive. We're looking at
a six-hour procedure minimum, and even then,
the odds aren't great. Fifty-fifty at best."
```

## Subtext Techniques

### Surface vs. Underneath

**On the Nose (Bad):**
```
JOHN: I'm angry at you for sleeping with my best friend!
MARY: I'm sorry, I was lonely and he was there!
```

**With Subtext (Good):**
```
JOHN: How was your day?
MARY: Fine. Yours?
JOHN: Fine.
     (beat)
     Tom called. Asked about Saturday.
MARY: What did you tell him?
JOHN: That I'd check with you.
     (long pause)
     Should I call him back?
```

### Subtext Tools

1. **Deflection** - Answering a different question
2. **Silence** - What isn't said
3. **Actions** - Doing opposite of saying
4. **Understatement** - Saying less than meant
5. **Topic change** - Avoiding the real issue
6. **Questions** - Answering with questions

## Naturalistic Dialogue

### Real Speech Patterns

```
People actually:
- Interrupt each other
- Trail off mid-sentence...
- Use filler words (um, uh, well)
- Repeat themselves
- Speak in fragments
- Don't always respond directly
```

### Dialogue Example

```fountain
                    SARAH
          So about last night--

                    MIKE
          Yeah, about that. Look--

                    SARAH
          No, let me--

                    MIKE
          I just want to say--

                    SARAH
          Mike.
              (beat)
          Let me talk. Please.

A long moment. Mike nods.

                    SARAH (CONT'D)
          I... I don't know what I want
          to say anymore.
```

## Dialogue Formatting

### Parentheticals

Use sparingly for:
- Tone that contradicts words: `(sarcastically)`
- Specific direction: `(to John)`
- Physical action with line: `(standing)`

**Don't** use for:
- Emotions the actor can interpret
- Directing the performance
- Every single line

### Beat

`(beat)` indicates a pause:
```fountain
                    JOHN
          I love you.
              (beat)
          I always have.
```

### Overlapping Dialogue

```fountain
                    SARAH
          I didn't mean to--
              (overlapping)
                    MIKE
          --you never mean to--
              (overlapping)
                    SARAH
          --if you'd just let me explain--
```

## Genre-Specific Dialogue

### Drama
- Subtext-heavy
- Emotional weight
- Character reveals
- Silences matter

### Comedy
- Setup/payback rhythm
- Surprise word choices
- Timing in phrasing
- Rule of threes

### Thriller
- Information control
- Tension building
- Double meanings
- Interrogation dynamics

### Action
- Short, punchy
- Physical verbs
- One-liners
- Under pressure

## Dialogue Checklist

- [ ] Could I identify the speaker without attribution?
- [ ] Is there subtext?
- [ ] Does it advance plot AND reveal character?
- [ ] Have I cut every unnecessary word?
- [ ] Does it sound speakable?
- [ ] Are the voices distinct?
- [ ] Is the rhythm varied?
- [ ] Does it create tension?

## Common Mistakes

1. **Exposition dumps** - Characters telling each other what they both know
2. **On the nose** - Saying exactly what they mean
3. **Same voice** - All characters sound alike
4. **Over-explaining** - Not trusting the audience
5. **Perfect grammar** - Real people don't speak perfectly
6. **Pointless chitchat** - Every line must earn its place

## Quick Fixes

| Problem | Solution |
|---------|----------|
| Too expository | Make them argue about it instead |
| Too long | Cut to essential meaning |
| Too similar | Add contrasting vocabulary |
| Too formal | Add contractions, fragments |
| Too perfect | Add interruptions, hesitation |
