# DNS Protocol Skill

Expert skill for DNS protocol implementation, configuration, and service discovery.

## Overview

This skill provides specialized capabilities for working with DNS at both the protocol and operational level. It covers DNS server configuration, DNSSEC, service discovery patterns, and DNS-based traffic management.

## Key Features

- DNS query execution and analysis
- All record type support (A, AAAA, CNAME, MX, SRV, TXT, etc.)
- BIND and CoreDNS configuration
- DNSSEC implementation and validation
- DNS-based service discovery

## When to Use

- Setting up DNS servers
- Implementing service discovery
- Debugging DNS resolution issues
- Configuring DNSSEC
- Analyzing DNS traffic

## Dependencies

- dig
- nslookup
- BIND utilities
- CoreDNS
- dnssec-tools
