---
name: document-redliner
description: Automated document comparison, redline generation, change tracking
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Bash
  - WebFetch
metadata:
  specialization: venture-capital
  domain: business
  skill-id: vc-skill-029
---

# Document Redliner

## Overview

The Document Redliner skill provides automated document comparison and redline generation for deal negotiations. It enables efficient tracking of changes across document versions and supports the definitive document negotiation process.

## Capabilities

### Document Comparison
- Compare document versions automatically
- Identify additions, deletions, and modifications
- Track formatting and structural changes
- Handle multi-party document exchanges

### Redline Generation
- Generate visual redline documents
- Create summary of material changes
- Produce change statistics and metrics
- Support multiple output formats

### Change Tracking
- Maintain full document history
- Track changes by party/source
- Provide change audit trail
- Support rollback to previous versions

### Negotiation Support
- Highlight substantive vs. minor changes
- Flag changes requiring attention
- Track issue resolution status
- Generate negotiation status reports

## Usage

### Compare Documents
```
Input: Two document versions
Process: Analyze differences
Output: Comparison report, change list
```

### Generate Redline
```
Input: Original, modified documents
Process: Create marked-up version
Output: Redlined document, change summary
```

### Track Negotiation Progress
```
Input: Document exchange history
Process: Analyze negotiation state
Output: Progress report, open issues
```

### Summarize Changes
```
Input: Redlined document
Process: Extract and summarize changes
Output: Executive change summary
```

## Document Types Supported

| Document | Typical Sections Tracked |
|----------|-------------------------|
| Stock Purchase Agreement | Reps, warranties, conditions |
| Investor Rights Agreement | Rights, obligations, governance |
| Voting Agreement | Voting provisions, board composition |
| Right of First Refusal | Transfer restrictions, procedures |
| Certificate of Incorporation | Share rights, preferences |

## Integration Points

- **Definitive Document Negotiation**: Core redlining skill
- **Contract Extractor**: Extract terms from documents
- **Closing Checklist Tracker**: Track doc completion
- **Deal Counsel Coordinator (Agent)**: Support legal work

## Comparison Features

| Feature | Description |
|---------|-------------|
| Word-level diff | Character-by-character changes |
| Semantic comparison | Meaning-based analysis |
| Structure tracking | Section/paragraph changes |
| Cross-reference checking | Internal reference consistency |

## Best Practices

1. Establish clean base document for comparison
2. Use consistent document naming conventions
3. Review substantive changes carefully
4. Maintain organized version history
5. Summarize changes for non-legal stakeholders
