---
name: donor-relationship-management
description: Cultivate and steward donor relationships including prospect research, personalized engagement strategies, gift acknowledgment, and impact reporting
allowed-tools: Read, Grep, Write, Edit, Glob, WebFetch, WebSearch
---

# Donor Relationship Management

Cultivate and steward donor relationships including prospect research, personalized engagement strategies, gift acknowledgment, and impact reporting.

## Overview

This skill enables effective donor cultivation and stewardship for arts and cultural organizations. It encompasses prospect research, relationship building, acknowledgment practices, and impact reporting to build lasting philanthropic partnerships.

## Capabilities

### Prospect Research
- Identify potential donors
- Assess giving capacity and affinity
- Research philanthropic history
- Analyze wealth indicators
- Track prospect status and moves

### Cultivation Strategies
- Develop personalized engagement plans
- Create meaningful touchpoints
- Involve leadership appropriately
- Build authentic relationships
- Move prospects through pipeline

### Gift Processing
- Acknowledge gifts promptly
- Process pledges and payments
- Manage donor recognition
- Handle restricted gifts appropriately
- Ensure compliance and reporting

### Stewardship and Impact
- Report on gift impact
- Provide personalized stewardship
- Recognize donors appropriately
- Maintain ongoing engagement
- Encourage continued giving

## Usage Guidelines

### Cultivation Process
1. Identify and research prospects
2. Qualify interest and capacity
3. Develop engagement strategy
4. Execute cultivation activities
5. Make thoughtful solicitation
6. Steward and recognize gifts

### Communication Standards
- Personalize all communications
- Express genuine gratitude
- Report impact specifically
- Respect donor preferences
- Maintain confidentiality

### Database Management
- Maintain accurate records
- Track all interactions
- Document giving history
- Note preferences and interests
- Generate appropriate reports

## Integration Points

### Related Processes
- Donor Cultivation Process
- Budget Management Process
- Strategic Planning Process

### Collaborating Skills
- grant-proposal-writing
- audience-analytics

## References

- AFP Fundraising Effectiveness Project
- Donor-centered fundraising principles
- Penelope Burk stewardship research
- CASE reporting standards
