# DP Optimizer

A skill for applying advanced dynamic programming optimizations.

## Overview

This skill applies sophisticated optimization techniques to DP solutions, reducing time and space complexity through methods like convex hull trick, divide and conquer optimization, and more.

## Key Features

- Automatic optimization detection
- Convex hull trick application
- Divide and conquer optimization
- Knuth optimization
- Space complexity reduction

## Optimization Categories

### Time Optimizations
- Convex Hull Trick
- Divide & Conquer DP
- Knuth Optimization
- Monotonic Queue/Deque

### Space Optimizations
- Rolling Array
- Bitmask Compression

## Related Skills

- SK-ALGO-010: dp-state-designer
- SK-ALGO-012: dp-pattern-library
- SK-ALGO-006: complexity-analyzer
