---
name: dsl-compiler-generator
description: Generate compilers and interpreters for domain-specific languages
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
metadata:
  specialization: computer-science
  domain: science
  category: programming-language-theory
  phase: 6
---

# DSL Compiler Generator

## Purpose

Provides expert guidance on generating compilers and interpreters for domain-specific languages from high-level specifications.

## Capabilities

- Parser generation from grammar
- Type checker generation from rules
- Interpreter generation from semantics
- Code generation templates
- Language workbench integration
- IDE support generation

## Usage Guidelines

1. **Grammar Design**: Define DSL syntax
2. **Parser Generation**: Generate parser from grammar
3. **Type System**: Implement type checking
4. **Semantics**: Implement interpreter or code generator
5. **IDE Integration**: Generate editor support

## Tools/Libraries

- ANTLR
- Xtext
- Racket
- MPS
