---
name: economic-indicator-tracker
description: Macroeconomic indicator monitoring and analysis skill with trend identification and forecasting
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Bash
metadata:
  specialization: finance-accounting
  domain: business
  category: economic-analysis
  priority: medium
  shared: true
---

# Economic Indicator Tracker

## Overview

The Economic Indicator Tracker skill provides comprehensive macroeconomic monitoring and analysis capabilities. It enables tracking of key economic indicators, trend identification, and forecasting to support financial planning and decision-making.

## Capabilities

### GDP, Inflation, Employment Tracking
- Real GDP growth monitoring
- CPI and PCE tracking
- Employment statistics
- Wage growth analysis
- Productivity metrics
- Consumer spending trends

### Leading/Lagging Indicator Analysis
- Leading Economic Index
- Coincident indicators
- Lagging indicators
- Conference Board data
- OECD indicators
- Regional variations

### Interest Rate Forecasting
- Fed funds rate tracking
- Forward rate analysis
- Fed communications parsing
- Market expectations
- Term premium analysis
- Policy rule modeling

### Yield Curve Analysis
- Yield curve construction
- Curve shape interpretation
- Spread analysis
- Inversion signals
- Duration analysis
- Credit spread monitoring

### Sector Correlation Analysis
- Sector sensitivity mapping
- Cyclical vs. defensive
- Industry correlations
- Factor analysis
- Regime identification
- Portfolio implications

### Economic Calendar Integration
- Data release scheduling
- Consensus expectations
- Actual vs. expected tracking
- Market reaction analysis
- Revision tracking
- Event prioritization

## Usage

### Economic Monitoring
```
Input: Indicator selection, time period, geographic focus
Process: Collect data, identify trends, generate analysis
Output: Economic dashboard, trend report, forecast implications
```

### Business Impact Analysis
```
Input: Economic scenario, business sensitivity, industry factors
Process: Model economic impact on business metrics
Output: Impact assessment, scenario planning input, risk factors
```

## Integration

### Used By Processes
- Economic Forecasting and Indicator Analysis
- Industry and Competitive Analysis
- Financial Modeling and Scenario Planning

### Tools and Libraries
- FRED API
- BLS API
- Economic databases
- Statistical analysis tools

### Cross-Specialization Use
- Supply Chain planning
- Real Estate analysis
- Business Strategy

## Best Practices

1. Establish regular monitoring cadence
2. Document data sources and methodology
3. Track forecast accuracy over time
4. Consider leading indicator signals
5. Maintain historical context for interpretation
6. Integrate with business planning processes
