---
name: elearning-storyboarding
description: Create detailed storyboards for interactive digital learning content specifying narration, visuals, interactions, and navigation
allowed-tools: Read, Grep, Write, Edit, Glob
---

# E-Learning Storyboarding

Create detailed storyboards for interactive digital learning content specifying narration, visuals, interactions, and navigation.

## Overview

This skill enables the creation of comprehensive storyboards for e-learning development. It encompasses specification of content, visuals, audio, interactions, and navigation to guide development of effective digital learning experiences.

## Capabilities

### Content Specification
- Write screen-level content
- Develop narration scripts
- Specify on-screen text
- Plan content chunking
- Sequence learning flow

### Visual Design
- Describe graphic requirements
- Specify layout elements
- Plan animation sequences
- Define visual metaphors
- Document image specifications

### Interaction Design
- Design learner interactions
- Specify click behaviors
- Plan branching scenarios
- Design knowledge checks
- Document feedback approaches

### Navigation Planning
- Define course structure
- Plan menu systems
- Design progress indicators
- Specify player controls
- Document completion rules

## Usage Guidelines

### Storyboarding Process
1. Outline course structure
2. Plan screen-level content
3. Write narration scripts
4. Describe visual elements
5. Design interactions
6. Document navigation
7. Review and revise

### Storyboard Elements
- Screen title and number
- Narration/audio script
- On-screen text
- Visual descriptions
- Interaction specifications
- Branching/navigation notes

### Best Practices
- One concept per screen
- Balance media elements
- Design meaningful interactions
- Provide clear feedback
- Ensure accessibility

## Integration Points

### Related Processes
- E-Learning Course Authoring
- SAM Model Implementation
- SCORM/xAPI Development

### Collaborating Skills
- multimedia-learning-design
- lms-configuration-administration
- accessibility-compliance-auditing

## References

- Allen Interactions SAM model
- E-learning storyboard templates
- Instructional design standards
- Multimedia learning principles
