---
name: electric-motor-design
description: Electric motor and drive unit design and optimization expertise
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Edit
  - WebFetch
  - WebSearch
  - Bash
metadata:
  version: "1.0"
  category: automotive-engineering
  tags:
    - electrification
    - motor
    - inverter
    - drive-unit
---

# Electric Motor Design Skill

## Purpose
Enable electric motor and drive unit design and optimization including electromagnetic analysis, thermal modeling, and control algorithm development.

## Capabilities
- Motor topology selection (PMSM, induction, SRM)
- Electromagnetic FEA simulation (JMAG, Motor-CAD, ANSYS Maxwell)
- Efficiency map generation and analysis
- Thermal modeling and cooling design
- NVH analysis for electric motors
- Demagnetization analysis
- Inverter sizing and selection
- Field-oriented control (FOC) algorithm development

## Usage Guidelines
- Select motor topology based on performance and cost requirements
- Optimize efficiency across typical drive cycles
- Design cooling for continuous and peak power requirements
- Analyze NVH characteristics for acceptable noise levels
- Validate demagnetization resistance at extreme temperatures
- Document motor specifications and control parameters

## Dependencies
- JMAG
- Motor-CAD
- ANSYS Maxwell
- MATLAB/Simulink

## Process Integration
- PTE-002: Electric Drive Unit Development
- PTE-003: Hybrid Powertrain Integration
- PTE-004: Powertrain Calibration and Optimization
