---
name: emissions-calibration
description: Engine emissions calibration and aftertreatment optimization expertise
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Edit
  - WebFetch
  - WebSearch
  - Bash
metadata:
  version: "1.0"
  category: automotive-engineering
  tags:
    - powertrain
    - emissions
    - calibration
    - aftertreatment
---

# Emissions Calibration Skill

## Purpose
Provide engine emissions calibration and aftertreatment optimization expertise for regulatory compliance across WLTP, RDE, and other emissions standards.

## Capabilities
- Engine map optimization (torque, spark, AFR)
- Catalyst light-off calibration
- SCR system calibration (urea dosing)
- GPF/DPF regeneration strategy
- RDE (Real Driving Emissions) compliance
- WLTP/FTP cycle optimization
- Cold start emissions reduction
- OBD-II monitor calibration

## Usage Guidelines
- Optimize engine maps for emissions and performance balance
- Calibrate catalyst systems for rapid light-off
- Design regeneration strategies for filter systems
- Validate RDE compliance under real-world conditions
- Document calibration parameters and rationale
- Coordinate with homologation for certification

## Dependencies
- ETAS INCA
- AVL CAMEO
- ATI Vision
- Emission test cells

## Process Integration
- PTE-003: Hybrid Powertrain Integration
- PTE-004: Powertrain Calibration and Optimization
- TVL-003: Homologation and Type Approval
