---
name: environmental-testing
description: Skill for environmental test campaign planning and execution
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Edit
  - WebFetch
  - WebSearch
  - Bash
metadata:
  version: "1.0"
  category: aerospace-engineering
  tags:
    - testing
    - environmental
    - qualification
    - validation
---

# Environmental Testing Skill

## Purpose
Provide environmental test campaign planning and execution capabilities for aerospace component and system qualification.

## Capabilities
- Vibration test specification (sine, random, shock)
- Thermal vacuum test planning
- EMI/EMC test requirements
- Acoustic testing specification
- Test sequence optimization
- Test-to-analysis correlation
- Qualification vs acceptance criteria
- Test data analysis and reporting

## Usage Guidelines
- Derive test levels from flight and ground environments
- Apply appropriate margins for qualification testing
- Sequence tests to minimize retest if failures occur
- Correlate test results with analytical predictions
- Document anomalies and corrective actions
- Generate comprehensive test reports for certification

## Dependencies
- Vibration control systems
- Test data analysis tools
- Environmental test chambers

## Process Integration
- AE-025: Environmental Testing Sequence
