---
name: epics-control-system
description: EPICS control system skill for accelerator and beamline instrument control and monitoring
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
metadata:
  specialization: physics
  domain: science
  category: lab-automation
  phase: 6
---

# EPICS Control System

## Purpose

Provides expert guidance on EPICS for accelerator and beamline control systems, including IOC configuration and channel access.

## Capabilities

- IOC configuration and deployment
- Channel Access protocol
- Archiver integration
- Alarm handling
- OPI screen development
- Python/caproto scripting

## Usage Guidelines

1. **IOC Setup**: Configure Input/Output Controllers
2. **Channels**: Define process variables and records
3. **Archiving**: Set up archiver for data logging
4. **Alarms**: Configure alarm handling
5. **Python Integration**: Use caproto or pyepics for scripting

## Tools/Libraries

- EPICS
- caproto
- pyepics
- phoebus
