---
name: esg-scorer
description: ESG rating calculation based on environmental, social, governance metrics
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Bash
  - WebFetch
metadata:
  specialization: venture-capital
  domain: business
  skill-id: vc-skill-019
---

# ESG Scorer

## Overview

The ESG Scorer skill provides systematic Environmental, Social, and Governance (ESG) assessment for venture capital investments. It calculates ESG ratings based on defined criteria and supports ESG-conscious investment decision-making and portfolio monitoring.

## Capabilities

### Environmental Assessment
- Evaluate carbon footprint and emissions
- Assess energy efficiency practices
- Review waste management and recycling
- Analyze environmental compliance and risks

### Social Assessment
- Evaluate diversity and inclusion practices
- Assess employee welfare and benefits
- Review community impact and engagement
- Analyze supply chain labor practices

### Governance Assessment
- Evaluate board composition and independence
- Assess transparency and reporting practices
- Review ethics policies and compliance
- Analyze stakeholder engagement

### ESG Scoring and Reporting
- Calculate composite ESG scores
- Benchmark against industry standards
- Track ESG improvement over time
- Generate ESG reports for LPs

## Usage

### Calculate ESG Score
```
Input: Company data, ESG questionnaire responses
Process: Apply scoring methodology
Output: ESG score, component breakdown
```

### Assess Environmental Impact
```
Input: Environmental data, industry context
Process: Analyze environmental metrics
Output: Environmental assessment, recommendations
```

### Evaluate Social Practices
```
Input: HR policies, employee data, practices
Process: Assess social metrics
Output: Social assessment, improvement areas
```

### Review Governance
```
Input: Governance documents, board composition
Process: Evaluate governance practices
Output: Governance assessment, recommendations
```

## ESG Framework

| Category | Key Metrics |
|----------|-------------|
| Environmental | Carbon emissions, energy use, waste, water |
| Social | Diversity, employee satisfaction, safety, community |
| Governance | Board independence, ethics, transparency, compliance |

## Integration Points

- **ESG Due Diligence**: Core scoring for ESG DD
- **Carbon Footprint Estimator**: Detailed environmental analysis
- **ESG Analyst (Agent)**: Support agent assessment
- **Quarterly Portfolio Reporting**: Track portfolio ESG

## Reporting Frameworks

- UN Principles for Responsible Investment (PRI)
- Sustainability Accounting Standards Board (SASB)
- Global Reporting Initiative (GRI)
- Task Force on Climate-related Financial Disclosures (TCFD)
- B Corp certification criteria

## Best Practices

1. Apply materiality-based approach by sector
2. Balance quantitative metrics with qualitative assessment
3. Track improvement trajectory, not just current state
4. Engage portfolio companies on ESG improvement
5. Align reporting with LP requirements and standards
