---
name: ethical-framework-application
description: Apply multiple ethical frameworks (deontological, consequentialist, virtue ethics, care ethics) systematically to moral problems and generate reasoned recommendations
allowed-tools:
  - Read
  - Write
  - Edit
  - Grep
  - Glob
  - Bash
---

# Ethical Framework Application Skill

Systematically apply diverse ethical frameworks to analyze moral problems and develop reasoned recommendations.

## Overview

The Ethical Framework Application skill enables systematic application of multiple ethical frameworks including deontological, consequentialist, virtue ethics, and care ethics approaches to analyze moral problems, evaluate options, and generate well-reasoned ethical recommendations.

## Capabilities

### Deontological Analysis
- Apply Kantian categorical imperative
- Identify rights and duties
- Assess universalizability of maxims
- Evaluate respect for persons
- Analyze rule-based considerations

### Consequentialist Reasoning
- Calculate expected outcomes
- Apply utilitarian principles
- Consider act vs. rule consequentialism
- Assess short and long-term effects
- Evaluate aggregate welfare

### Virtue Ethics Application
- Identify relevant virtues
- Consider character development
- Apply Aristotelian frameworks
- Assess eudaimonia
- Evaluate moral exemplars

### Care Ethics Integration
- Analyze relationships and dependencies
- Consider context and particularity
- Evaluate caring responses
- Assess vulnerability and need
- Balance care and justice

### Comparative Analysis
- Apply multiple frameworks to same case
- Identify convergence and divergence
- Synthesize insights across approaches
- Navigate framework conflicts
- Generate balanced recommendations

## Usage Guidelines

### When to Use
- Analyzing ethical dilemmas
- Evaluating policy options
- Guiding professional ethics
- Teaching moral reasoning
- Developing ethical guidelines

### Best Practices
- Apply multiple frameworks systematically
- Consider all affected parties
- Document reasoning clearly
- Acknowledge framework limitations
- Remain open to revision

### Integration Points
- Bioethics Deliberation skill
- Socratic Dialogue Facilitation skill
- Conceptual Analysis skill
- Scholarly Literature Synthesis skill

## References

- Applied Ethics Case Analysis process
- Moral Reasoning Framework Application process
- Ethical Theory Comparison process
- Ethics Consultant Agent
