---
name: ethnographic-coding-thematics
description: Code qualitative field data, identify emergent themes, and develop grounded interpretations using NVivo/Atlas.ti methodologies
allowed-tools: Read, Grep, Write, Edit, Glob, Bash
---

# Ethnographic Coding and Thematics

Code qualitative field data, identify emergent themes, and develop grounded interpretations using systematic qualitative analysis methodologies.

## Overview

This skill enables systematic analysis of ethnographic and qualitative data. It encompasses coding procedures, thematic analysis, and interpretation development to derive meaningful insights from field research data.

## Capabilities

### Coding Methods
- Open coding
- Axial coding
- Selective coding
- In vivo coding
- Process coding

### Theme Development
- Pattern identification
- Category formation
- Theme refinement
- Saturation assessment
- Theoretical integration

### Software Utilization
- NVivo analysis
- Atlas.ti coding
- Data organization
- Query development
- Visualization creation

### Interpretation
- Thick description
- Pattern explanation
- Theoretical development
- Contextual understanding
- Reflexive analysis

## Usage Guidelines

### Coding Process
1. Prepare data for analysis
2. Conduct initial open coding
3. Develop coding framework
4. Apply axial coding
5. Identify themes
6. Develop interpretations
7. Verify with data

### Coding Best Practices
- Code iteratively
- Maintain codebook
- Use memo writing
- Check for saturation
- Verify interpretations

### Quality Criteria
- Systematic procedures
- Transparent documentation
- Member checking
- Thick description
- Reflexivity

## Integration Points

### Related Processes
- Participant Observation Protocol
- Ethnographic Interview Methodology
- Visual Ethnography Documentation

### Collaborating Skills
- research-ethics-irb-navigation
- oral-history-interview-technique
- topic-modeling-text-mining

## References

- Grounded theory methodology
- Qualitative data analysis texts
- NVivo/Atlas.ti guides
- Ethnographic analysis frameworks
