---
name: ethnographic-research
description: Conduct participant observation, fieldwork, immersion, and thick description documentation in diverse cultural settings
allowed-tools:
  - Read
  - Write
  - Edit
  - Grep
  - Glob
  - Bash
---

# Ethnographic Research Skill

Conduct participant observation, fieldwork, and thick description documentation in diverse cultural settings.

## Overview

The Ethnographic Research skill enables conducting participant observation, extended fieldwork, cultural immersion, and thick description documentation in diverse cultural settings for deep understanding of social phenomena and cultural practices.

## Capabilities

### Participant Observation
- Field entry strategies
- Role negotiation
- Observation techniques
- Field note taking
- Reflexive practice

### Fieldwork Methods
- Site selection
- Access negotiation
- Rapport building
- Data gathering
- Field relationships

### Cultural Immersion
- Language competence
- Cultural learning
- Daily life participation
- Insider perspective
- Sustained engagement

### Thick Description
- Contextual documentation
- Meaning interpretation
- Detail capture
- Narrative construction
- Interpretive writing

### Ethical Practice
- Informed consent
- Confidentiality
- Reciprocity
- Community benefit
- Exit strategies

## Usage Guidelines

### When to Use
- Understanding cultural practices
- Exploring social phenomena
- Documenting community life
- Building theory
- Generating hypotheses

### Best Practices
- Spend adequate time in field
- Document thoroughly
- Maintain reflexivity
- Respect communities
- Write detailed notes

### Integration Points
- Qualitative Analysis skill
- Interview and Facilitation skill
- Research Ethics and IRB skill
- Mixed Methods Integration skill

## References

- Ethnographic Fieldwork process
- In-Depth Interview Protocol process
- Focus Group Facilitation process
- Qualitative Research Specialist agent
