---
name: exhibition-design
description: Plan and design exhibition layouts including spatial arrangement, object placement, lighting, graphics, and visitor flow optimization for diverse audiences
allowed-tools: Read, Grep, Write, Edit, Glob, WebFetch
---

# Exhibition Design

Plan and design exhibition layouts including spatial arrangement, object placement, lighting, graphics, and visitor flow optimization for diverse audiences.

## Overview

This skill enables the planning and design of compelling exhibition experiences. It covers spatial design, object placement, interpretive graphics, lighting design, and visitor flow to create engaging and accessible exhibitions for diverse audiences.

## Capabilities

### Spatial Planning
- Analyze gallery spaces and constraints
- Develop floor plan layouts
- Create circulation patterns
- Plan sightlines and focal points
- Accommodate accessibility requirements

### Object Placement
- Group objects thematically or chronologically
- Consider conservation requirements
- Balance visual weight and composition
- Plan case and mount configurations
- Integrate multimedia elements

### Lighting Design
- Select appropriate light levels for objects
- Create ambient and accent lighting schemes
- Consider UV and heat impacts
- Balance natural and artificial light
- Design dramatic effects where appropriate

### Graphics and Interpretation
- Plan signage hierarchy and placement
- Design panel layouts and typography
- Integrate multimedia stations
- Create accessible text alternatives
- Develop wayfinding systems

## Usage Guidelines

### Design Process
1. Analyze curatorial narrative and objects
2. Study gallery space and constraints
3. Develop conceptual design schemes
4. Create detailed floor plans and elevations
5. Specify materials, finishes, and fixtures
6. Coordinate with fabrication and installation

### Visitor Experience Principles
- Create clear orientation and wayfinding
- Vary pacing and experience density
- Provide multiple engagement levels
- Ensure accessibility throughout
- Consider dwell time and fatigue

### Technical Requirements
- Meet conservation lighting standards
- Ensure structural stability of displays
- Provide adequate security measures
- Plan for maintenance access
- Document all specifications

## Integration Points

### Related Processes
- Exhibition Development Process
- Visitor Experience Design Process

### Collaborating Skills
- interpretive-writing
- accessibility-compliance
- digital-engagement-strategy

## References

- AAM Excellence in Exhibition guidelines
- Smithsonian Guidelines for Accessible Exhibition Design
- IES Museum and Art Gallery Lighting
- Exhibition design professional standards
