---
name: facilitation-workshop-delivery
description: Design and facilitate engaging professional development workshops using adult learning principles and active learning strategies
allowed-tools: Read, Grep, Write, Edit, Glob
---

# Facilitation and Workshop Delivery

Design and facilitate engaging professional development workshops using adult learning principles and active learning strategies.

## Overview

This skill enables effective design and delivery of professional development workshops. It encompasses adult learning principles, active learning strategies, facilitation techniques, and evaluation to create impactful learning experiences for professionals.

## Capabilities

### Workshop Design
- Define learning outcomes
- Structure session flow
- Select activities and methods
- Create participant materials
- Plan time allocation

### Adult Learning Application
- Apply andragogy principles
- Leverage learner experience
- Ensure relevance and application
- Support self-direction
- Address motivation

### Facilitation Techniques
- Manage group dynamics
- Ask effective questions
- Facilitate discussions
- Handle challenging situations
- Encourage participation

### Active Learning Strategies
- Design collaborative activities
- Create problem-based scenarios
- Use experiential methods
- Incorporate reflection
- Enable peer learning

## Usage Guidelines

### Design Process
1. Assess learner needs
2. Define learning outcomes
3. Design session flow
4. Select activities
5. Create materials
6. Plan facilitation approach
7. Prepare evaluation

### Facilitation Best Practices
- Establish psychological safety
- Balance structure and flexibility
- Manage time effectively
- Ensure equitable participation
- Connect to real-world application

### Engagement Strategies
- Start with relevant hooks
- Vary activities and pacing
- Include movement and interaction
- Provide practice opportunities
- Close with clear takeaways

## Integration Points

### Related Processes
- Teaching Effectiveness Workshop Design
- Peer Observation and Feedback
- TPACK Integration Training

### Collaborating Skills
- learning-needs-analysis
- learning-transfer-design
- quality-assurance-review

## References

- Knowles adult learning theory
- Brookfield skilled teacher
- Workshop design frameworks
- Active learning research
