---
name: fallacy-detection-analysis
description: Identify formal and informal logical fallacies in arguments, classify fallacy types, and explain precisely why reasoning fails with reference to logical principles
allowed-tools:
  - Read
  - Write
  - Edit
  - Grep
  - Glob
  - Bash
---

# Fallacy Detection and Analysis Skill

Identify and analyze logical fallacies in arguments with precise classification and explanation of reasoning failures.

## Overview

The Fallacy Detection and Analysis skill enables identification of formal and informal logical fallacies in arguments, precise classification of fallacy types, clear explanation of why reasoning fails with reference to logical principles, and development of sound reasoning practices.

## Capabilities

### Formal Fallacy Detection
- Identify invalid argument forms
- Recognize affirming the consequent
- Detect denying the antecedent
- Identify undistributed middle
- Analyze quantifier errors

### Informal Fallacy Detection
- Recognize relevance fallacies
- Identify presumption fallacies
- Detect ambiguity fallacies
- Recognize emotional appeals
- Identify causal fallacies

### Fallacy Classification
- Apply standard taxonomies
- Distinguish fallacy types
- Identify overlapping categories
- Document classification reasoning
- Use precise terminology

### Reasoning Analysis
- Explain why arguments fail
- Reference logical principles
- Provide clear examples
- Suggest corrections
- Teach sound reasoning

### Critical Application
- Apply to real arguments
- Analyze texts systematically
- Evaluate public discourse
- Improve own reasoning
- Teach critical thinking

## Usage Guidelines

### When to Use
- Analyzing arguments
- Teaching critical thinking
- Reviewing manuscripts
- Evaluating discourse
- Improving reasoning

### Best Practices
- Apply classifications carefully
- Explain failures clearly
- Avoid fallacy hunting
- Consider context
- Teach constructively

### Integration Points
- Argument Mapping and Reconstruction skill
- Formal Logic Analysis skill
- Evidence and Justification Assessment skill
- Socratic Dialogue Facilitation skill

## References

- Fallacy Identification and Classification process
- Argument Reconstruction and Analysis process
- Critical Thinking Assessment process
- Logic Analyst Agent
- Critical Thinking Educator Agent
