---
name: financial-dashboard-generator
description: Automated financial dashboard and KPI visualization skill with executive reporting capabilities
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Bash
metadata:
  specialization: finance-accounting
  domain: business
  category: reporting-analytics
  priority: medium
  shared: true
---

# Financial Dashboard Generator

## Overview

The Financial Dashboard Generator skill provides automated financial reporting and visualization capabilities. It enables KPI tracking, variance analysis presentation, and executive reporting through dynamic dashboards.

## Capabilities

### KPI Calculation and Trending
- Financial KPI computation
- Operational metric tracking
- Period-over-period trending
- YTD/MTD calculations
- Benchmark comparison
- Target tracking

### Variance Waterfall Charts
- Budget vs. actual bridges
- Period-over-period bridges
- Component breakdown
- Cumulative impact
- Interactive drill-down
- Custom categorization

### Executive Summary Generation
- Automated narrative creation
- Key highlight extraction
- Exception identification
- Trend commentary
- Action item tracking
- Performance context

### Board Deck Automation
- Template population
- Consistent formatting
- Chart generation
- Data validation
- Version control
- Distribution management

### Drill-Down Report Creation
- Hierarchical navigation
- Detail access
- Filter capabilities
- Cross-referencing
- Export functionality
- User customization

### Mobile-Responsive Dashboards
- Responsive design
- Touch optimization
- Offline capability
- Push notifications
- Quick access metrics
- Simplified views

## Usage

### Executive Dashboard
```
Input: Financial data, KPI definitions, reporting period
Process: Calculate metrics, generate visualizations, create narrative
Output: Executive dashboard, KPI report, variance analysis
```

### Board Reporting Package
```
Input: Period results, comparative data, management commentary
Process: Populate templates, generate charts, compile package
Output: Board presentation, supporting schedules, appendices
```

## Integration

### Used By Processes
- Variance Analysis and Reporting
- Month-End Close Process
- Annual Budget Development

### Tools and Libraries
- Power BI API
- Tableau API
- Financial visualization libraries
- Reporting automation tools

### Cross-Specialization Use
- Any domain requiring executive reporting
- KPI visualization across specializations

## Best Practices

1. Standardize KPI definitions across organization
2. Maintain consistent visual design language
3. Build for self-service exploration
4. Include data freshness indicators
5. Provide context for metrics
6. Enable action from insights
