---
name: flight-test-planning
description: Skill for comprehensive flight test planning and execution support
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Edit
  - WebFetch
  - WebSearch
  - Bash
metadata:
  version: "1.0"
  category: aerospace-engineering
  tags:
    - testing
    - flight-test
    - validation
    - certification
---

# Flight Test Planning Skill

## Purpose
Provide comprehensive flight test planning capabilities including test point definition, instrumentation specification, and safety analysis.

## Capabilities
- Test point definition and prioritization
- Test card generation
- Instrumentation requirements specification
- Safety of flight analysis
- Flight test technique selection
- Data analysis planning
- Risk assessment and mitigation
- Test schedule optimization

## Usage Guidelines
- Define clear test objectives aligned with certification requirements
- Prioritize test points based on risk and criticality
- Specify instrumentation to capture required data
- Conduct thorough safety of flight analysis before each test
- Select appropriate test techniques for each maneuver
- Plan for real-time monitoring and abort criteria

## Dependencies
- Flight test management tools
- Data analysis systems
- Telemetry systems

## Process Integration
- AE-024: Flight Test Planning
