---
name: formal-logic-analysis
description: Apply propositional, predicate, and modal logic systems to formalize arguments, construct proofs, and evaluate validity using symbolic notation and truth tables
allowed-tools:
  - Read
  - Write
  - Edit
  - Grep
  - Glob
  - Bash
---

# Formal Logic Analysis Skill

Apply formal logic systems to analyze, formalize, and evaluate arguments with rigorous symbolic methods.

## Overview

The Formal Logic Analysis skill enables systematic application of propositional, predicate, and modal logic systems to formalize arguments, construct proofs, evaluate validity, and assess soundness using symbolic notation, truth tables, and proof procedures.

## Capabilities

### Propositional Logic
- Translate natural language arguments into propositional form
- Construct truth tables for validity assessment
- Apply natural deduction rules
- Identify logical equivalences and tautologies
- Evaluate argument validity through truth-functional analysis

### Predicate Logic
- Formalize arguments with quantifiers and predicates
- Apply universal and existential instantiation/generalization
- Construct formal proofs in first-order logic
- Analyze logical relations and inferences
- Handle multiple quantification and scope issues

### Modal Logic
- Apply necessity and possibility operators
- Analyze arguments involving modality
- Work with different modal systems (K, T, S4, S5)
- Evaluate modal validity
- Apply modal logic to philosophical arguments

### Proof Construction
- Build natural deduction proofs
- Apply inference rules systematically
- Construct indirect proofs
- Use conditional proof techniques
- Verify proof correctness

## Usage Guidelines

### When to Use
- Formalizing philosophical arguments
- Testing argument validity
- Analyzing logical structure
- Teaching formal reasoning
- Evaluating philosophical positions

### Best Practices
- Translate arguments carefully and completely
- Check translations against original meaning
- Use appropriate logical system for the argument type
- Document proof steps clearly
- Verify validity independently when possible

### Integration Points
- Argument Mapping and Reconstruction skill
- Fallacy Detection and Analysis skill
- Philosophical Writing and Argumentation skill
- Conceptual Analysis skill

## References

- Formal Logic Analysis process
- Modal Logic Application process
- Argument Reconstruction and Analysis process
- Logic Analyst Agent
