---
name: fraud-risk-assessor
description: Fraud risk assessment skill based on the fraud triangle with red flag detection
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Bash
metadata:
  specialization: finance-accounting
  domain: business
  category: audit
  priority: medium
---

# Fraud Risk Assessor

## Overview

The Fraud Risk Assessor skill provides comprehensive fraud risk assessment capabilities based on the fraud triangle framework. It enables red flag identification, data analytics for anomaly detection, and systematic fraud risk evaluation.

## Capabilities

### Fraud Triangle Analysis
- Pressure/incentive identification
- Opportunity assessment
- Rationalization indicators
- Risk factor documentation
- Industry-specific considerations
- Management override risk

### Red Flag Identification
- Financial statement red flags
- Behavioral indicators
- Operational anomalies
- Control environment weaknesses
- Related party concerns
- Going concern indicators

### Data Analytics for Anomaly Detection
- Transaction pattern analysis
- Unusual relationship identification
- Trend deviation detection
- Outlier identification
- Clustering analysis
- Network analysis

### Benford's Law Analysis
- First digit analysis
- Second digit testing
- First-two digits examination
- Conformity testing
- Deviation significance
- Result interpretation

### Duplicate Detection
- Exact match identification
- Fuzzy matching
- Near-duplicate detection
- Vendor duplicate analysis
- Payment duplicate screening
- Employee duplicate review

### Journal Entry Testing
- Manual entry identification
- Non-standard timing
- Round number analysis
- Unusual account combinations
- User behavior analysis
- Close period entries

## Usage

### Fraud Risk Assessment
```
Input: Entity information, industry factors, control environment
Process: Evaluate fraud triangle factors, identify red flags
Output: Fraud risk assessment report, high-risk areas, testing focus
```

### Forensic Data Analysis
```
Input: Transaction data, population characteristics, risk areas
Process: Apply analytics, identify anomalies, investigate exceptions
Output: Anomaly report, investigation recommendations, findings
```

## Integration

### Used By Processes
- Fraud Risk Assessment and Investigation
- Internal Audit Planning and Execution
- SOX Compliance and Testing

### Tools and Libraries
- Forensic analytics tools
- Benford's law libraries
- Data analytics platforms
- Investigation management tools

## Best Practices

1. Maintain confidentiality throughout assessment
2. Document all red flags with supporting evidence
3. Consider industry-specific fraud schemes
4. Update risk assessment for changes
5. Coordinate with legal counsel as appropriate
6. Preserve evidence chain of custody
