# FSM Design Skill

Specialized skill for finite state machine design and optimization in FPGAs.

## Purpose

This skill provides FSM expertise, enabling:
- Robust control logic implementation
- Optimal state encoding selection
- Safe FSM coding patterns
- Performance-optimized state machines

## Key Features

- Moore and Mealy machine design
- State encoding selection (one-hot, binary, Gray)
- Illegal state recovery implementation
- State diagram and transition table generation
- Area and speed optimization
- FSM assertion development

## Integration

Used primarily with:
- FSM Design Process
- RTL Module Architecture Process
- VHDL Module Development Process
- Verilog/SystemVerilog Design Process

## Related

- SK-013 in skills-agents-backlog.md
- RTL Design Expert Agent (AG-001)
