---
name: fx-hedging-strategy-modeler
description: Foreign exchange exposure analysis and hedging strategy skill with hedge effectiveness testing
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Bash
metadata:
  specialization: finance-accounting
  domain: business
  category: treasury
  priority: lower
---

# FX Hedging Strategy Modeler

## Overview

The FX Hedging Strategy Modeler skill provides comprehensive foreign exchange risk management capabilities. It supports exposure identification, hedge instrument selection, and hedge accounting compliance under ASC 815.

## Capabilities

### Exposure Identification and Quantification
- Transaction exposure identification
- Translation exposure measurement
- Economic exposure analysis
- Forecasted transaction assessment
- Intercompany exposure netting
- Net investment hedging

### Hedge Instrument Selection
- Forward contract pricing
- FX option valuation
- Cross-currency swap modeling
- Natural hedge identification
- Synthetic hedge structures
- Cost-benefit analysis

### Hedge Ratio Optimization
- Optimal hedge ratio calculation
- Rolling hedge programs
- Layered hedging strategies
- Hedge horizon determination
- Tenor selection
- Portfolio hedge consideration

### Hedge Effectiveness Testing (ASC 815)
- Prospective effectiveness testing
- Retrospective effectiveness measurement
- Dollar offset method
- Regression analysis
- Matched terms assessment
- Critical terms match

### Mark-to-Market Valuation
- Forward point calculation
- Option pricing models
- Swap valuation
- Counterparty credit adjustment
- Collateral impact
- Fair value hierarchy

### VaR Calculation for FX
- Historical simulation
- Parametric VaR
- Monte Carlo simulation
- Expected shortfall
- Stress testing scenarios
- Back-testing validation

## Usage

### Hedging Strategy Development
```
Input: FX exposures, risk tolerance, market conditions
Process: Analyze exposures, evaluate instruments, optimize strategy
Output: Hedge program recommendations, cost analysis, implementation plan
```

### Hedge Accounting Compliance
```
Input: Hedging relationships, effectiveness requirements
Process: Document relationships, perform effectiveness testing
Output: Hedge documentation, effectiveness results, journal entries
```

## Integration

### Used By Processes
- Foreign Exchange Risk Management
- Cash Flow Forecasting and Liquidity Management
- Financial Modeling and Scenario Planning

### Tools and Libraries
- Bloomberg API
- Reuters Eikon
- FX pricing models
- Treasury management systems

## Best Practices

1. Establish FX risk management policy
2. Document all hedging relationships contemporaneously
3. Monitor hedge effectiveness continuously
4. Review and update exposures regularly
5. Consider total cost of hedging programs
6. Coordinate with accounting on hedge accounting eligibility
