---
name: genre-analysis-film
id: SK-FTV-012
version: 1.0.0
description: Analyze and apply film/TV genre conventions, tropes, and audience expectations
specialization: film-tv-production
---

# Genre Analysis (Film) Skill

## Purpose

Understand and apply genre conventions to meet audience expectations while finding fresh approaches. Genres are contracts with viewers—knowing the rules lets you fulfill or subvert them effectively.

## Major Genres

### Action
**Core Elements:**
- Physical conflict as resolution
- Clear hero vs. villain
- Stakes are life/death
- Spectacle and set pieces

**Conventions:**
- Opening action hook
- Training/preparation sequence
- Escalating confrontations
- Climactic battle
- Hero's moment of doubt

**Subgenres:** Martial arts, war, spy, disaster, superhero

### Comedy
**Core Elements:**
- Humor as primary emotion
- Characters in absurd situations
- Social commentary through laughter
- Happy or ironic ending

**Conventions:**
- Setup and payoff
- Rule of threes
- Fish out of water
- Escalating complications
- Comedic timing

**Subgenres:** Romantic comedy, dark comedy, satire, parody, slapstick

### Drama
**Core Elements:**
- Character-driven conflict
- Emotional truth
- Realistic stakes
- Internal transformation

**Conventions:**
- Slow burn development
- Subtext-heavy dialogue
- Moral complexity
- Ambiguous endings acceptable

**Subgenres:** Family drama, legal, medical, political, historical

### Horror
**Core Elements:**
- Fear as primary emotion
- Threat to survival
- Darkness (literal/metaphorical)
- Violation of safety

**Conventions:**
- Opening kill/scare
- Investigation/discovery
- Rules of the threat
- False scares
- Climactic confrontation
- Final girl/survivor
- Ambiguous ending (is it really over?)

**Subgenres:** Slasher, supernatural, psychological, body horror, found footage

### Thriller
**Core Elements:**
- Suspense and tension
- Protagonist in danger
- Cat and mouse dynamics
- High stakes

**Conventions:**
- Mystery/puzzle element
- Ticking clock
- Plot twists
- Unreliable elements
- Confrontation with antagonist

**Subgenres:** Psychological, crime, spy, legal, tech

### Science Fiction
**Core Elements:**
- Speculative premise
- "What if?" exploration
- Technology or science central
- Commentary on humanity

**Conventions:**
- World-building
- Exposition challenges
- Visual spectacle
- Philosophical questions
- Rules of the world

**Subgenres:** Space opera, cyberpunk, dystopia, time travel, hard sci-fi

### Fantasy
**Core Elements:**
- Magical/supernatural elements
- Mythic storytelling
- Good vs. evil
- Hero's journey

**Conventions:**
- World-building heavy
- Chosen one narrative
- Quest structure
- Magical system rules
- Mentor figure

**Subgenres:** Epic, urban, dark, fairy tale, historical

### Romance
**Core Elements:**
- Central love story
- Emotional journey
- Obstacles to love
- Satisfying resolution

**Conventions:**
- Meet-cute
- Initial antagonism or misunderstanding
- Growing attraction
- Dark moment/separation
- Declaration and reunion

**Subgenres:** Romantic comedy, romantic drama, period romance

## Genre Expectations

### Audience Contract

| Genre | Viewer Expects |
|-------|----------------|
| Action | Excitement, spectacle, clear victory |
| Comedy | Laughter, happy ending, release |
| Drama | Emotional catharsis, truth |
| Horror | Fear, dread, survival |
| Thriller | Tension, surprise, resolution |
| Sci-Fi | Ideas, wonder, speculation |
| Romance | Love, emotion, satisfaction |

### Tone Markers

**Action:** High energy, clear morality, physical
**Comedy:** Light, irreverent, self-aware
**Drama:** Serious, nuanced, grounded
**Horror:** Dread, unease, violation
**Thriller:** Tense, paranoid, uncertain
**Sci-Fi:** Intellectual, expansive, questioning
**Romance:** Warm, emotional, hopeful

## Genre Blending

### Successful Hybrids

| Hybrid | Example | Balance |
|--------|---------|---------|
| Action-Comedy | Guardians of the Galaxy | 60/40 action/comedy |
| Horror-Comedy | Shaun of the Dead | Alternating tones |
| Sci-Fi/Horror | Alien | Sci-fi setting, horror structure |
| Drama-Thriller | Prisoners | Drama depth, thriller tension |
| Romance-Comedy | When Harry Met Sally | Equal measure |

### Blending Rules
1. One genre should be primary
2. Tonal shifts need management
3. Core audience expectations must be met
4. Genre tropes should complement

## Subverting Expectations

### Effective Subversion
- Know the rules before breaking them
- Subvert with purpose
- Maintain core emotional promise
- Replace expectation with something better

### Examples
- **Scream:** Horror that's self-aware of horror rules
- **The Cabin in the Woods:** Meta-commentary on horror
- **500 Days of Summer:** Anti-romantic comedy
- **No Country for Old Men:** Western without resolution

## Genre Analysis Template

```markdown
## Genre Analysis: [PROJECT]

### Primary Genre
[Genre name]

### Subgenre(s)
[If applicable]

### Core Audience
[Who watches this genre]

### Expected Elements
- [Element 1]
- [Element 2]
- [Element 3]

### How This Project Fulfills Expectations
- [How we meet expectation 1]
- [How we meet expectation 2]

### How This Project Subverts/Freshens
- [Fresh take 1]
- [Fresh take 2]

### Tone Approach
[How we handle tone]

### Comparable Titles
- [Comp 1] - because [reason]
- [Comp 2] - because [reason]
- [Comp 3] - because [reason]
```

## Genre Checklist

- [ ] Primary genre identified
- [ ] Core conventions understood
- [ ] Audience expectations mapped
- [ ] Key tropes identified
- [ ] Fresh angle articulated
- [ ] Tone approach defined
- [ ] Comparable titles listed
- [ ] Subversion is purposeful
- [ ] Emotional promise maintained

## Genre by Format

### Feature Film
- Clearer genre identity
- Complete arc in one viewing
- Higher production values expected

### TV Series
- Genre blending more common
- Character development over time
- Episodic vs. serialized affects genre use

### Limited Series
- Novelistic approach
- Genre can evolve
- More complexity allowed

### Short Film
- Concentrate on one genre element
- Subversion more acceptable
- Experimental audience
