---
name: gis-mapping-humanities
description: Create spatial visualizations and geographic analyses for historical and cultural research questions using QGIS/ArcGIS
allowed-tools: Read, Grep, Write, Edit, Glob, Bash, WebFetch
---

# GIS Mapping for Humanities

Create spatial visualizations and geographic analyses for historical and cultural research questions using GIS tools.

## Overview

This skill enables spatial analysis for humanities research. It encompasses GIS mapping, spatial visualization, and geographic analysis to explore spatial dimensions of historical and cultural phenomena.

## Capabilities

### Spatial Data Creation
- Point digitization
- Polygon creation
- Line features
- Attribute data
- Georeferencing

### Map Design
- Thematic mapping
- Cartographic design
- Legend creation
- Scale management
- Projection selection

### Spatial Analysis
- Proximity analysis
- Density mapping
- Pattern detection
- Network analysis
- Change over time

### Visualization
- Interactive maps
- Web mapping
- Story maps
- Animated displays
- Print cartography

## Usage Guidelines

### Mapping Process
1. Define research question
2. Identify spatial data needs
3. Gather or create data
4. Process and clean data
5. Conduct analysis
6. Design visualization
7. Interpret results

### Data Considerations
- Historical accuracy
- Source documentation
- Uncertainty representation
- Temporal precision
- Attribution

### Design Principles
- Clear visual hierarchy
- Appropriate symbolization
- Readable labeling
- Contextual information
- Accessible design

## Integration Points

### Related Processes
- Spatial Humanities Mapping
- Data Visualization for Cultural Research
- Network Analysis for Humanities

### Collaborating Skills
- metadata-standards-implementation
- topic-modeling-text-mining
- tei-text-encoding

## References

- Spatial humanities resources
- QGIS documentation
- Historical GIS projects
- Cartographic design principles
