# Godot Shaders Skill

## Overview

The Godot Shaders skill enables custom shader development in Godot Engine.

## Purpose

Shaders define visual appearance. This skill enables:

- **Visual Shaders**: Node-based editing
- **Code Shaders**: GLSL-like syntax
- **Effect Types**: Spatial, Canvas, Particles
- **Custom Effects**: Unique visual styles

## Use Cases

1. **Stylized Graphics**: Toon, outline
2. **Environmental Effects**: Water, foliage
3. **Post-Processing**: Filters, distortion
4. **2D Effects**: Sprite manipulation

## Processes That Use This Skill

- **VFX Implementation** (`vfx-implementation.js`)
- **Art Asset Pipeline** (`art-asset-pipeline.js`)

## Related Skills

- `godot-development`: Core Godot development
- `glsl`: OpenGL shading
- `shader-effects`: Effect patterns
