---
name: graph-algorithm-library
description: Comprehensive graph algorithms implementation
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
metadata:
  specialization: mathematics
  domain: science
  category: combinatorics
  phase: 6
---

# Graph Algorithm Library

## Purpose

Provides comprehensive graph algorithms for combinatorial analysis and network computations.

## Capabilities

- Shortest path algorithms (Dijkstra, Bellman-Ford, Floyd-Warshall)
- Network flow algorithms
- Matching algorithms
- Graph coloring
- Planarity testing
- Graph isomorphism

## Usage Guidelines

1. **Representation**: Choose appropriate graph representation
2. **Algorithm Selection**: Match algorithm to problem structure
3. **Complexity Analysis**: Consider time/space tradeoffs
4. **Sparse Graphs**: Use specialized algorithms for sparse graphs

## Tools/Libraries

- NetworkX
- igraph
- LEMON
- Boost Graph Library
