# gRPC Protocol Skill

Expert skill for gRPC protocol implementation, debugging, and performance optimization.

## Overview

This skill provides specialized capabilities for building, testing, and debugging gRPC services. It covers service definition, code generation, streaming patterns, and performance optimization.

## Key Features

- Protocol Buffer schema design and validation
- Multi-language code generation
- Streaming pattern implementation (unary, client/server streaming, bidirectional)
- gRPC-Web browser compatibility
- Load balancing and interceptor configuration

## When to Use

- Designing gRPC service APIs
- Implementing streaming services
- Debugging gRPC connection issues
- Configuring gRPC load balancing
- Testing gRPC services

## Dependencies

- protoc
- grpcurl
- buf
- evans
