---
name: handling-qualities
description: Specialized skill for aircraft handling qualities evaluation
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Edit
  - WebFetch
  - WebSearch
  - Bash
metadata:
  version: "1.0"
  category: aerospace-engineering
  tags:
    - flight-dynamics
    - handling-qualities
    - pilot-interface
    - certification
---

# Handling Qualities Assessment Skill

## Purpose
Provide specialized handling qualities evaluation capabilities for aircraft certification and pilot-vehicle interface optimization.

## Capabilities
- MIL-STD-1797 compliance checking
- Cooper-Harper rating prediction
- Time response criteria evaluation
- Frequency response requirements
- PIO susceptibility analysis
- Category/Phase/Level determination
- Pilot opinion correlation
- Flying qualities demonstration planning

## Usage Guidelines
- Define appropriate flight phases and categories for evaluation
- Apply correct criteria based on aircraft class and mission
- Consider pilot workload and task performance
- Evaluate PIO susceptibility across frequency range
- Correlate analytical predictions with pilot evaluations
- Document handling qualities substantiation for certification

## Dependencies
- MATLAB
- Flying qualities tools
- Simulation interfaces

## Process Integration
- AE-012: Handling Qualities Assessment
- AE-011: Flight Control Law Development
