---
name: health-data-integration
description: Facilitate interoperability between health IT systems including EHR, HIE, and clinical decision support through HL7, FHIR, and other healthcare data standards
allowed-tools: Read, Grep, Write, Edit, Glob, Bash, WebFetch
---

# Health Data Integration

Facilitate interoperability between health IT systems including EHR, HIE, and clinical decision support through HL7, FHIR, and other healthcare data standards.

## Overview

This skill enables integration of healthcare information systems. It encompasses interoperability standards implementation, data exchange configuration, and system integration to support seamless health information sharing.

## Capabilities

### Interoperability Standards
- HL7 v2 messaging
- HL7 FHIR resources
- CDA document exchange
- CCDA implementation
- Direct messaging

### System Integration
- EHR integration
- HIE connectivity
- Lab interfaces
- Pharmacy integration
- Device connectivity

### Data Exchange
- ADT notifications
- Clinical summaries
- Lab results
- Medication data
- Imaging reports

### Data Quality
- Data validation
- Mapping and transformation
- Error handling
- Reconciliation
- Audit logging

## Usage Guidelines

### Integration Process
1. Define integration requirements
2. Assess system capabilities
3. Select appropriate standards
4. Design interface specifications
5. Develop and configure
6. Test thoroughly
7. Deploy and monitor

### FHIR Implementation
- Identify required resources
- Configure API endpoints
- Implement authentication
- Handle search parameters
- Manage subscriptions

### Data Governance
- Establish data standards
- Define ownership
- Implement access controls
- Maintain audit trails
- Ensure privacy compliance

## Integration Points

### Related Processes
- EHR Implementation Methodology
- HIE Integration
- Clinical Decision Support Implementation

### Collaborating Skills
- clinical-workflow-analysis
- regulatory-compliance-assessment
- clinical-decision-support-rules

## References

- HL7 International standards
- ONC interoperability rules
- FHIR implementation guides
- USCDI data standards
