# Helm Charts Skill

Expert Helm chart development and management skill for Kubernetes package management.

## ID
SK-005

## Category
Kubernetes Packaging

## Quick Reference

| Aspect | Details |
|--------|---------|
| Slug | `helm-charts` |
| Primary Use | Helm chart creation, validation, and release management |
| Dependencies | Helm CLI, kubectl |
| Process Integration | kubernetes-setup.js, service-mesh.js, idp-setup.js |

## Key Capabilities

- **Chart Generation**: Create Helm charts from Kubernetes manifests
- **Validation**: Lint and test chart configurations
- **Template Debugging**: Troubleshoot Go template rendering
- **Dependency Management**: Handle chart dependencies and sub-charts
- **Release Lifecycle**: Manage installs, upgrades, and rollbacks

## When to Use

Use this skill when you need to:
- Package Kubernetes applications as Helm charts
- Validate chart structure and best practices
- Debug template rendering issues
- Manage Helm release lifecycle
- Configure chart dependencies

## Related

- **Skills**: kubernetes-ops (SK-001), gitops (SK-010)
- **Agents**: kubernetes-expert (AG-001), platform-engineer (AG-008)
