---
name: hermeneutical-interpretation
description: Conduct systematic textual interpretation using historical-critical, literary, and phenomenological methods while attending to context, genre, and interpretive traditions
allowed-tools:
  - Read
  - Write
  - Edit
  - Grep
  - Glob
  - Bash
---

# Hermeneutical Interpretation Skill

Conduct rigorous textual interpretation using multiple hermeneutical methods and interpretive approaches.

## Overview

The Hermeneutical Interpretation skill enables systematic textual interpretation using historical-critical, literary, and phenomenological methods while attending to historical context, literary genre, authorial intent, and interpretive traditions in philosophical and theological texts.

## Capabilities

### Historical-Critical Method
- Analyze historical context of texts
- Identify authorship and dating
- Reconstruct original audience
- Trace textual transmission
- Evaluate source materials

### Literary Analysis
- Identify genre conventions
- Analyze rhetorical structures
- Examine narrative elements
- Evaluate linguistic features
- Assess literary devices

### Phenomenological Reading
- Bracket presuppositions
- Attend to phenomena as given
- Describe intentional structures
- Explore horizons of meaning
- Practice hermeneutical openness

### Reception History
- Trace interpretive traditions
- Analyze influential readings
- Identify hermeneutical shifts
- Evaluate contemporary interpretations
- Situate own interpretation

### Integrative Interpretation
- Synthesize multiple approaches
- Balance historical and contemporary
- Navigate interpretive tensions
- Develop coherent readings
- Justify interpretive choices

## Usage Guidelines

### When to Use
- Interpreting philosophical texts
- Analyzing religious scriptures
- Reading historical sources
- Engaging canonical works
- Teaching textual analysis

### Best Practices
- Consider multiple interpretive levels
- Document methodological choices
- Acknowledge interpretive tradition
- Remain attentive to text details
- Engage with scholarship

### Integration Points
- Comparative Religion Analysis skill
- Scholarly Literature Synthesis skill
- Conceptual Analysis skill
- Philosophical Writing and Argumentation skill

## References

- Textual Exegesis and Interpretation process
- Comparative Textual Analysis process
- Canonical and Contextual Reading process
- Hermeneutics Specialist Agent
- Philosophical Theologian Agent
