---
name: highspot-content
description: Highspot sales enablement for content delivery and analytics
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Bash
  - WebFetch
metadata:
  specialization: sales
  domain: business
  priority: P1
  integration-points:
    - Highspot API
---

# Highspot Content

## Overview

The Highspot Content skill provides integration with Highspot's sales enablement platform for content search and delivery, pitch analytics, training content access, and guided selling plays. This skill ensures sales teams can find, customize, and share the right content efficiently.

## Capabilities

### Content Search & Delivery
- Search content library intelligently
- Access content by category and tag
- Customize content for recipients
- Track content sharing activity

### Pitch Analytics
- Monitor pitch engagement metrics
- Track viewing time and depth
- Identify engaged prospects
- Analyze pitch effectiveness

### Training Content
- Access training materials and courses
- Track learning progress
- Assess knowledge retention
- Certificate completion tracking

### Guided Selling
- Access sales plays for scenarios
- Follow recommended actions
- Track play adoption
- Measure play effectiveness

## Usage

### Content Search
```
Search for relevant content to share with a prospect based on their industry and buying stage.
```

### Pitch Review
```
Analyze pitch analytics to identify which shared content generated the most prospect engagement.
```

### Play Execution
```
Execute a guided selling play for a specific sales scenario with recommended content and actions.
```

## Enhances Processes

- sales-playbook-development
- sales-methodology-training
- challenger-sale-teaching

## Dependencies

- Highspot subscription
- Content organization and tagging
- Play configuration
