---
name: hil-test-automation
description: Hardware-in-the-loop test development and automation expertise
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Edit
  - WebFetch
  - WebSearch
  - Bash
metadata:
  version: "1.0"
  category: automotive-engineering
  tags:
    - testing
    - hil
    - automation
    - validation
---

# HIL Test Automation Skill

## Purpose
Provide hardware-in-the-loop test development and automation expertise for comprehensive ECU validation and regression testing.

## Capabilities
- dSPACE ControlDesk/AutomationDesk scripting
- NI TestStand/LabVIEW integration
- Plant model integration (ASM, CarSim, GT-SUITE)
- Test case generation from requirements
- Fault injection test design
- Signal manipulation and residual bus simulation
- Regression test automation
- Test report generation

## Usage Guidelines
- Develop plant models with appropriate fidelity
- Generate test cases from requirements traceability
- Implement fault injection for safety validation
- Automate regression testing for continuous integration
- Document test procedures and acceptance criteria
- Generate comprehensive test reports

## Dependencies
- dSPACE HIL
- NI PXI/VeriStand
- Vector VT System

## Process Integration
- TVL-002: Hardware-in-the-Loop Testing
- ADA-004: Simulation and Virtual Validation
- SAF-001: Functional Safety Development (ISO 26262)
