# HLS C/C++ to RTL Skill

Expert skill for High-Level Synthesis, converting C/C++ algorithms to optimized RTL for FPGA acceleration.

## Purpose

This skill provides deep expertise in HLS development, enabling:
- Algorithm acceleration on FPGAs
- C/C++ to hardware conversion
- Performance optimization through pragmas
- Interface synthesis for system integration

## Key Features

- HLS-synthesizable C/C++ coding
- Pragma application (PIPELINE, UNROLL, ARRAY_PARTITION)
- Interface synthesis configuration
- Dataflow optimization
- Fixed-point arithmetic handling
- Report analysis and iteration

## Integration

Used primarily with:
- HLS Development Process
- Hardware-Software Codesign Process
- IP Core Integration Process

## Related

- SK-006 in skills-agents-backlog.md
- HLS Expert Agent (AG-005)
